# 画面設計書 319-GraphQL Explorer

## 概要

本ドキュメントは、GitLabにおけるGraphQL Explorer画面の設計仕様を定義するものである。

### 本画面の処理概要

GraphQL Explorer画面は、GitLabのGraphQL APIをインタラクティブに探索・テストするためのツールである。GraphiQLをベースにした開発者向けのAPIエクスプローラで、クエリの作成・実行、スキーマドキュメントの参照、クエリ履歴の管理などが可能である。

**業務上の目的・背景**：GitLabはGraphQL APIを提供しており、開発者はこのAPIを使用してGitLabの機能にプログラマティックにアクセスできる。GraphQL Explorerは、APIの学習、クエリの検証、デバッグを行うための統合開発環境を提供する。これにより、外部ツールを使用せずにGitLab内でAPIの動作を確認でき、開発効率が向上する。

**画面へのアクセス方法**：直接URL `/-/graphql-explorer` にアクセスする。

**主要な操作・処理内容**：
1. GraphQLクエリの入力・編集
2. クエリの実行
3. 結果の表示
4. スキーマドキュメントの参照
5. クエリ履歴の管理
6. 変数の設定

**画面遷移**：
- この画面は独立したツールとして機能
- 他の画面からのリンクによるアクセス

**権限による表示制御**：
- 認証済みユーザーがアクセス可能（APIアクセスには認証が必要）
- 実行可能なクエリはユーザーの権限に依存

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 101 | GraphQL API | 主機能 | GraphQL APIエクスプローラ |

## 画面種別

ツール/開発者向け

## URL/ルーティング

- パス: `/-/graphql-explorer`
- コントローラ: `API::Graphql::GraphqlExplorerController#show`
- ルート定義: `config/routes/api.rb` (6行目)

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| クエリ | 入力 | String | いいえ | GraphQLクエリ文字列 |
| 変数 | 入力 | JSON | いいえ | クエリ変数 |
| オペレーション名 | 入力 | String | いいえ | 実行するオペレーション名 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| クエリエディタ | Component | GraphQLクエリ入力エリア |
| 結果パネル | JSON | クエリ実行結果 |
| ドキュメントエクスプローラ | Component | スキーマドキュメント |
| 履歴パネル | Component | 過去のクエリ履歴 |
| パフォーマンスバー | Component | パフォーマンス情報（有効時） |

## イベント仕様

### 1-クエリ実行

実行ボタン押下またはショートカットキーでクエリを実行する。

**処理フロー**：
1. クエリと変数を取得
2. POST `/api/graphql` にリクエスト送信
3. レスポンスを結果パネルに表示
4. エラーがあれば表示

### 2-スキーマ探索

ドキュメントエクスプローラでスキーマを参照する。

**処理フロー**：
1. イントロスペクションクエリを実行
2. スキーマ情報を取得
3. ナビゲーション可能な形式で表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クエリ実行 | - | 可変 | GraphQL APIを通じて各種操作 |

※データベースへの影響は実行されるGraphQLクエリに依存する。クエリ（読み取り）とミューテーション（書き込み）の両方が可能。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| Loading | Loading... | 初期ロード中 |
| エラー | GraphQLエラーメッセージ | クエリ実行エラー時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 認証エラー | 401エラーを返す（GraphQL API側） |
| 構文エラー | GraphQLエラーレスポンスとして表示 |
| タイムアウト | エラーメッセージを表示 |

## 備考

- GraphiQLライブラリをベースに実装
- パフォーマンスバーが有効な場合、専用スタイルが適用される
- CSRFトークンとAction Cable接続情報がページに含まれる
- `gon` によって相対URLルートなどの設定が渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | graphql_explorer_controller.rb | `app/controllers/api/graphql/graphql_explorer_controller.rb` | シンプルなコントローラ構造を理解する |

**主要処理フロー**:
1. **6-7行目**: `Gitlab::GonHelper` と `WithPerformanceBar` のインクルード
2. **9-11行目**: `show` アクションで `add_gon_variables` を呼び出し

**読解のコツ**: このコントローラは非常にシンプルで、主な処理はフロントエンドのJavaScript（GraphiQL）で行われる。`add_gon_variables` でクライアントに設定情報を渡している。

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/api/graphql/graphql_explorer/show.html.haml` | 独自のHTMLレイアウト構造を理解する |

**主要処理フロー**:
- **1-2行目**: HTML5ドキュメントとしてレンダリング
- **6-7行目**: CSRFトークンとAction Cable設定を含める
- **8行目**: `Gon::Base.render_data` でクライアント設定を渡す
- **10-11行目**: スタイルシートとWebpackバンドルを読み込み
- **12行目**: パフォーマンスバー有効時にクラスを追加
- **13-20行目**: パフォーマンスバーのレンダリング（有効時）
- **21行目**: GraphiQLコンテナをレンダリング

#### Step 3: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | api.rb | `config/routes/api.rb` | GraphQL Explorer のルート定義 |

**主要処理フロー**:
- **4行目**: GraphQL APIエンドポイント `/api/graphql`
- **6行目**: GraphQL Explorer `/-/graphql-explorer`

### プログラム呼び出し階層図

```
GET /-/graphql-explorer
    │
    └─ API::Graphql::GraphqlExplorerController#show
           │
           ├─ add_gon_variables
           │      └─ クライアント設定をGonに追加
           │
           └─ show.html.haml
                  │
                  ├─ csrf_meta_tags
                  ├─ action_cable_meta_tag
                  ├─ Gon::Base.render_data
                  │
                  ├─ page_bundles/graphql_explorer (CSS)
                  ├─ graphql_explorer (JS Bundle)
                  │
                  └─ #graphiql-container
                         │
                         └─ GraphiQL App (JavaScript)
                                │
                                └─ POST /api/graphql
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GraphQLクエリ        ───▶  GraphiQL                  ───▶  クエリ結果
                          │
                          ▼
                    POST /api/graphql
                          │
                          ▼
                    GraphQL Resolver
                          │
                          ▼
                    データベース/サービス
                          │
                          ▼
                    JSONレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| graphql_explorer_controller.rb | `app/controllers/api/graphql/graphql_explorer_controller.rb` | コントローラ | リクエスト処理 |
| show.html.haml | `app/views/api/graphql/graphql_explorer/show.html.haml` | ビュー | 画面テンプレート |
| api.rb | `config/routes/api.rb` | ルーティング | URLルート定義 |
| graphql_explorer_bundle.js | `app/assets/javascripts/graphql_explorer/` | JavaScript | GraphiQLアプリ |
| graphql_explorer.scss | `app/assets/stylesheets/page_bundles/graphql_explorer.scss` | スタイル | 画面スタイル |
| graphql_controller.rb | `app/controllers/graphql_controller.rb` | コントローラ | GraphQL API実行 |
